function [op]=udpgettconv(b,type,rows)
%function [op]=udpgettconv(b,type,rows)
% Supplied with a vector of bytes and type information and number of rows
%  this function converts into the double representation of whatever type is requested
% b       : Vector of data
% type    : type of data - 0 gives 8 bit uint ,1 gives 8 bit int ...etc
% rows    : the number of rows in the target matrix_type
% op      : th output conversion in double format
%
%  Ian Stothers - 2000 through March 2021
%  Embedded uint2float Ian S 29 mar 2022
% To Do
% Complex floats and others
%
op=[];
msb=max(size(b));
if (min(size(b))>0)
 switch(type)
  case 0 % uint8
   d=b;
   epc=msb;
  case 1 % sint8
   d=bitand(b,127)-bitand(b,128);
   epc=msb;
  case 2 % uint16le
   d=b(1:2:msb)+(2^8)*b(2:2:msb);
   epc=msb/2;
  case 3 % sint16le
   d=b(1:2:msb)+(2^8)*b(2:2:msb);
   d=bitand(d,(2^15)-1)-(bitand(d,(2^15)));
   epc=msb/2;
  case 4 % uint32le
   d=b(1:4:msb)+(2^8)*b(2:4:msb)+(2^16)*b(3:4:msb)+(2^24)*b(4:4:msb);
   epc=msb/4;
  case 5 % sint32le
   d=b(1:4:msb)+(2^8)*b(2:4:msb)+(2^16)*b(3:4:msb)+(2^24)*b(4:4:msb);
   d=bitand(d,(2^31)-1)-bitand(d,(2^31));
   epc=msb/4;
  case 6 % float32le
   d=b(1:4:msb)+(2^8)*b(2:4:msb)+(2^16)*b(3:4:msb)+(2^24)*b(4:4:msb);
   d=uint2float(d);
   epc=msb/4;
  case 10 % string
   d=char(b);
   epc=msb;
 otherwise
 end
 cols=epc/rows;
 op=double(reshape(d,rows,cols));
 if (type==10)
   op=char(op);
 endif
endif
endfunction

function [op]=uint2float(p_data)
sb=floor(p_data/(2.^31));
eb=bitand(floor(p_data/(2.^23)),255)-127;
mb=double(floor(bitand(p_data,(2.^23)-1))/(2.^23));
op=real(((-1).^sb).*(2.^eb).*(1+mb));
op=single((p_data~=0).* op);
endfunction
